/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.mu;

import com.cisco.pt.EncodedBuffer;
import com.cisco.pt.UUID;
import com.cisco.pt.impl.UUIDImpl;
import com.cisco.pt.mu.MultiUserMessage;
import com.cisco.pt.mu.PTSaveInfo;
import java.util.ArrayList;

public class MUSaveNetReqMessage
extends MultiUserMessage {
    public UUID saveReqId = new UUIDImpl("{00000000-0000-0000-0000-000000000000}");
    public UUID requestorId = new UUIDImpl("{00000000-0000-0000-0000-000000000000}");
    public int depthInfo = 0;
    public int timeoutInfo = 0;
    public int saveOrder = 0;
    public String clusterId = "";
    public ArrayList<PTSaveInfo> fullySaved = new ArrayList();
    public ArrayList<PTSaveInfo> partiallySaved = new ArrayList();

    public MUSaveNetReqMessage() {
        super.setType(PTMP_TYPE_MUSAVENETREQ);
    }

    public static MUSaveNetReqMessage getMessage(EncodedBuffer buffer) {
        MUSaveNetReqMessage msg = new MUSaveNetReqMessage();
        msg.saveReqId = buffer.getUUID();
        msg.requestorId = buffer.getUUID();
        msg.depthInfo = buffer.getInt();
        msg.timeoutInfo = buffer.getInt();
        msg.saveOrder = buffer.getInt();
        msg.clusterId = buffer.getString();
        int fullLen = buffer.getInt();
        for (int i = 0; i < fullLen; ++i) {
            msg.fullySaved.get((int)i).ptid = buffer.getUUID();
        }
        int partLen = buffer.getInt();
        for (int j = 0; j < partLen; ++j) {
            UUID ptid = buffer.getUUID();
            String clusterId = buffer.getString();
            int depthLeft = buffer.getInt();
            msg.partiallySaved.set(j, new PTSaveInfo(ptid, clusterId, depthLeft));
        }
        return msg;
    }

    public void encodeTypeAndPayload(EncodedBuffer buffer) {
        buffer.putInt(super.getType());
        buffer.putUUID(this.saveReqId);
        buffer.putUUID(this.requestorId);
        buffer.putInt(this.depthInfo);
        buffer.putInt(this.timeoutInfo);
        buffer.putInt(this.saveOrder);
        buffer.putString(this.clusterId);
        buffer.putInt(this.fullySaved.size());
        for (int i = 0; i < this.fullySaved.size(); ++i) {
            buffer.putUUID(this.fullySaved.get((int)i).ptid);
        }
        buffer.putInt(this.partiallySaved.size());
        for (int j = 0; j < this.partiallySaved.size(); ++j) {
            buffer.putUUID(this.partiallySaved.get((int)j).ptid);
            buffer.putString(this.partiallySaved.get((int)j).clusterId);
            buffer.putInt(this.partiallySaved.get((int)j).depthLeft);
        }
        buffer.flip();
    }

    public String toString() {
        String str = new String();
        str = "[MUSaveNetReqMessage: \n";
        str = str + "        saveReqId: " + this.saveReqId + "\n";
        str = str + "      requestorId: " + this.requestorId + "\n";
        str = str + "        depthInfo: " + this.depthInfo + "\n";
        str = str + "      timeoutInfo: " + this.timeoutInfo + "\n";
        str = str + "        saveOrder: " + this.saveOrder + "\n";
        str = str + "        clusterId: " + this.clusterId + "\n";
        str = str + "]";
        return str;
    }
}

